implementation module StdBitmap


//	Clean Object I/O library, version 1.2
//	Interface functions for drawing bitmaps.


import	StdBool, StdFile, StdInt
import	intrface, osbitmap, ospicture
import	commondef
import	StdMaybe, StdPicture


openBitmap :: !{#Char} !*env -> (!Maybe Bitmap,!*env)	| FileSystem env
openBitmap name env
	# (ok,file,env)		= fopen name FReadData env
	| not ok
		= (Nothing,env)
	# (ok,osBitmap,file)= OSreadBitmap file
    # (_,env)			= fclose file env
    | not ok
    	= (Nothing,env)
    | otherwise
		= (Just (toBitmap osBitmap),env)

getBitmapSize :: !Bitmap -> Size
getBitmapSize bitmap
	= fromTuple (OSgetBitmapSize (fromBitmap bitmap))

resizeBitmap :: !Bitmap !Size -> Bitmap
resizeBitmap bitmap size=:{w,h}
	| w<0 || h<0
		= Error "resizeBitmap" "StdBitmap" "a Size record with negative components was passed"
	| otherwise
		= toBitmap (OSresizeBitmap (w,h) (fromBitmap bitmap))

instance Drawables Bitmap where
	draw :: !Bitmap !*Picture -> *Picture
	draw bitmap picture
		# (origin,pen,pictContext,tb)	= peekPicture picture
		# (pictContext,tb)				= OSdrawBitmap (fromBitmap bitmap) (toTuple pen.penPos) (toTuple origin) pictContext tb
		= unpeekPicture origin pen pictContext tb
	
	drawAt :: !Point !Bitmap !*Picture -> *Picture
	drawAt pos bitmap picture
		# (origin,pen,pictContext,tb)	= peekPicture picture
		# (pictContext,tb)				= OSdrawBitmap (fromBitmap bitmap) (toTuple pos) (toTuple origin) pictContext tb
		= unpeekPicture origin pen pictContext tb
	
	undraw :: !Bitmap !*Picture -> *Picture
	undraw bitmap picture
		= unfill {box_w=w,box_h=h} picture
	where
		(w,h)	= OSgetBitmapSize (fromBitmap bitmap)
	
	undrawAt :: !Point !Bitmap !*Picture -> *Picture
	undrawAt pos bitmap picture
		= unfillAt pos {box_w=w,box_h=h} picture
	where
		(w,h)	= OSgetBitmapSize (fromBitmap bitmap)
